const mongoose = require('mongoose');

const agentSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
        trim: true
    },
    systemPrompt: {
        type: String,
        required: true
    },
    openingMessage: {
        type: String,
        required: true
    },
    voiceId: {
        type: String,
        trim: true,
        default: '21m00Tcm4TlvDq8ikWAM' // Default Rachel
    },
    voiceName: {
        type: String,
        trim: true,
        default: 'Rachel'
    },
    useCustomVoice: {
        type: Boolean,
        default: false
    },
    createdBy: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    }
}, {
    timestamps: true
});

const Agent = mongoose.model('Agent', agentSchema);

module.exports = Agent;
