const mongoose = require('mongoose');

const settingsSchema = new mongoose.Schema({
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true,
        unique: true
    },
    twilioSid: {
        type: String,
        default: ''
    },
    twilioToken: {
        type: String,
        default: ''
    },
    fromNumber: {
        type: String,
        default: ''
    },
    openRouterKey: {
        type: String,
        default: ''
    },
    elevenLabsKey: {
        type: String,
        default: ''
    },
    deepgramKey: {
        type: String,
        default: ''
    },
    recordingEnabled: {
        type: Boolean,
        default: true
    },
    autoAnalysisEnabled: {
        type: Boolean,
        default: false
    },
    timeFormat: {
        type: String, // '12' or '24'
        default: '12',
        enum: ['12', '24']
    }
}, {
    timestamps: true
});

const Settings = mongoose.model('Settings', settingsSchema);

module.exports = Settings;
